
;;;Bosse-engineering                                                                                       
;;;Dipl.-Ing. Jrn Bosse                                                                                   
;;;Am Klei 5                                                                                               
;;;38458 Velpke                                                                                            
;;;Tel. 05364 / 989 677                                                                                    
;;;mobil. 0176 / 282 323 51                                                                                
;;;bosse@bosse-engineering.com                                                                             
;;;                                                                                                        
;;;--------------------------------------------------------------------------------------------------------
;;;Funktion c: TTP - Tastatur-PAN: es wird ber definierte Tasten der Tastatur der PAN ausgelst, wobei    
;;;die PAN-Richtungen kreisfrmig in 50-gon / 45-Abstnden definiert sind. Die PAN-Distanz kann           
;;;eingestellt werden. Die PAN_Funktion kann im WKS oder im BKS verwendet werden.			   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;globale Variablen:										   	   
;;;- JB_TTP$DCL$_[x]_po (Positionen der Dialogfenster)							   
;;;- JB_TTP_$DCL$_File (temporre DCL-Datei)								   
;;;                                                                              Jrn Bosse, 19.02.24	   
;;;--------------------------------------------------------------------------------------------------------


;;;Settings, Einstellungen
(defun c:TTPS ( / )
  (JB_TTP 'T)
  )

;;;aufrufenden Funktionen
(defun c:TTP ( / )
  (JB_TTP nil)
  )

;;;Intro
(defun JB_TTP:Intro (str / )
  (princ "\nerstellt durch Bosse-engineering - www.bosse-engineering.com\n")
  (princ "\n----------------------TTP(1.0), 19.02.24----------------------")
  (princ str)
  (princ "\n--------------------------------------------------------------")
  )




;;;Variablenliste
(defun JB_TTP:v_liste ( / )
  '(
     ( "DboxSettings" . (
                         ( "Dbox1" .
                            (
                             ("JB_1_e1" . "1")
                             ("JB_1_e2" . "2")
                             ("JB_1_e3" . "3")
                             ("JB_1_e4" . "4")
                             ("JB_1_e5" . "5")
                             ("JB_1_e6" . "5")
                             ("JB_1_e7" . "7")
                             ("JB_1_e8" . "8")
                             ("JB_1_e9" . "9")
                             ("JB_1_e0" . "5.0")
                             
                                                         
                             )
                          )
                         )
      ))
  )


;;;Pfad fr SIC-Datei in Windows-User
(defun JB_TTP:pfad_ini ( / )
  (strcat (JBf_String:Userpfad:WinUser
                           "LispData\\acad\\"     ;;;Hier ndern, wenn anderer Pfad gewnscht, z.B. MeineTools\\Sicherungen\\ => Der LAufwerksbuchstabe c:\\ wird automatisch gegen das Windows-Benutzerverzeichnis 
                           )"TTP_sic.lsp")  ;;;getauscht, z.B. c:\\User\\[WindowsUsername]\\LispData\\acad\\
  )

;;;Hauptfunktion
(defun JB_TTP (DboxFlag / PFAD_INI V_LISTE)
  (vl-load-com)

  (setq pfad_ini (JB_TTP:pfad_ini))

  ;;;ab AutoCAD 2014, setzen von vertrauenswrdigen Pfaden fr Sicherungsdateien
  (if (JBf_AcadSystem:TrustedPaths?)
    (JBf_AcadSystem:TrustedPaths:Add (strcat(car(fnsplitl pfad_ini))"...")))

    (if (not(setq v_liste (if (findfile pfad_ini)
                          (load pfad_ini)nil)))
    (JBf_SIC:sichern
      (setq v_liste (JB_TTP:v_liste))pfad_ini nil))
  
  (vla-startundomark (vla-get-activedocument(vlax-get-acad-object)))
  (JBf_init
    '(("CMDECHO" 0)
      ("DIMZIN" 3)
      ))
  
  
  (JB_TTP:Intro "\nTTP: Tastatur-PAN.")

  
  (if DboxFlag
    (progn
      (if (not
            (or (and JB_TTP_$DCL$_File(findfile JB_TTP_$DCL$_File))
                (setq JB_TTP_$DCL$_File (JB_TTP:dcl:Write))))
        (progn
          (alert "Die DCL-Datei konnte nicht geschrieben werden.")
          (exit)))
      (JB_TTP:Dbox1 v_liste pfad_ini)
      )
    (progn
      (setq Settings&Dbox1 (JB_TTP:v_liste:DboxSettings:get "Dbox1" v_liste))
      (JB_TTP:Dbox1:exe))
    )
      
   
  (princ "\nEnde.")
  (JBf_Reinit)
  (vla-endundomark (vla-get-activedocument(vlax-get-acad-object))) 
  (princ)
  )

 

(defun  JB_TTP:v_liste:DboxSettings:get (key v_liste / )
  (cdr(assoc key(cdr (assoc "DboxSettings" v_liste))))
)


(defun JB_TTP:v_liste:DboxSettings:put (key liste v_liste / DboxList) 
  (setq DboxList (cdr (assoc "DboxSettings" v_liste)))
  (setq DBoxList (JBf_list:subst:gc DBoxList liste key))
  (setq v_liste (JBf_list:subst:gc v_liste DBoxList "DboxSettings"))
  v_liste
  )


 
;;;DBox 1
(defun JB_TTP:Dbox1 (v_liste pfad_ini / A DCLID OK SETTINGS&DBOX1 error&DBox1)

  (setq Settings&Dbox1 (JB_TTP:v_liste:DboxSettings:get "Dbox1" v_liste))
  
  (while (not (member ok '(1 99)))
    (setq DclId (JBf_Dcl:Load_dialog JB_TTP_$DCL$_File "JB_TTP_1" JB_TTP$DCL$_1_po))
    (JB_TTP:Dbox1:set)
    (JB_TTP:Dbox1:mode)
    (mapcar '(lambda (A) (action_tile A (strcat "(JB_TTP:Dbox1:action \"" A "\")")))
            '("JB_1_b1"              
              "cancel"
              "accept"
             )
    )
    (setq ok (start_dialog))
    (unload_dialog DclId)

    (cond
      ((= ok 1) ;;;Tastatur-PAN starten
       (setq v_liste (JB_TTP:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
       (JBf_SIC:sichern v_liste pfad_ini nil)
       (JB_TTP:Dbox1:exe)
       )

      ((= ok 99) ;;;Ende
       (setq v_liste (JB_TTP:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
       (JBf_SIC:sichern v_liste pfad_ini nil)
       )
      )
    )
  
  )



;;;Textobjekt picken
(defun JB_TTP:Dbox1:Action:TextPick (RealFlag key / TEXTWERT VLA-OBJ)
  (if (and(not(vl-catch-all-error-p
            (setq TextWert(vl-catch-all-apply 'nentsel(list "\nPicken Sie ein Textobjekt:")))))
          TextWert
          (setq vla-obj (vlax-ename->vla-object(car TextWert)))
          (or(vlax-property-available-p vla-obj 'TextString)
             (alert "Das gepickte Objekt beinhaltet keinen Textwert."))
          (setq TextWert (vla-get-TextString vla-obj)))
    (progn
      (if RealFlag
        (setq TextWert (atof(vl-string-subst "." "," TextWert))))
      (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 TextWert key)))
    )
  )



             

;;;Action (Variable global in Aufrufender Funktion)
(defun JB_TTP:Dbox1:action (key / )
  (cond
    ((= key "JB_1_b1")
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "1" "JB_1_e1"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "2" "JB_1_e2"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "3" "JB_1_e3"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "4" "JB_1_e4"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "5" "JB_1_e5"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "6" "JB_1_e6"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "7" "JB_1_e7"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "8" "JB_1_e8"))
     (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 "9" "JB_1_e9"))
     (JB_TTP:Dbox1:set)
     (JB_TTP:Dbox1:mode)
     )
    ((= key "accept") ;;;OK, Polylinie whlen
     (JB_TTP:Dbox1:get)
     (if error&DBox1
       (progn
         (alert "Ungltige Tastaturfestlegung.")
         (JB_TTP:Dbox1:mode)
         )
       (setq JB_TTP$DCL$_1_po (done_dialog 1))
       )
     )
    
    ((= key "cancel") ;;;Ende
     (JB_TTP:Dbox1:get)
     (if error&DBox1
       (progn
         (alert "Ungltige Tastaturfestlegung.")
         (JB_TTP:Dbox1:mode)
         )
       (setq JB_TTP$DCL$_1_po (done_dialog 99))
       )
     )
    )
  )



;;;DBox1: getten
(defun JB_TTP:Dbox1:get ( / N TASTENLIST)
 (setq error&DBox1 nil)
  
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e1")"JB_1_e1"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e2")"JB_1_e2"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e3")"JB_1_e3"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e4")"JB_1_e4"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e5")"JB_1_e5"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e6")"JB_1_e6"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e7")"JB_1_e7"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e8")"JB_1_e8"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(get_tile "JB_1_e9")"JB_1_e9"))
  (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1(vl-string-subst "." ","(get_tile "JB_1_e0"))"JB_1_e0"))

  (setq n 0)
  (while (and(not error&DBox1)(<=(setq n (+ n 1))9))
    (if (not (member (cdr(assoc (strcat "JB_1_e" (itoa n))Settings&dbox1))TastenList))
      (setq TastenList (cons (cdr(assoc (strcat "JB_1_e" (itoa n))Settings&dbox1))TastenList))
      (setq error&DBox1 (strcat "e" (itoa n)))
      )
    )
  )

;;;DBox1: setten
(defun JB_TTP:Dbox1:set ( / X)
  (mapcar '(lambda(X)(set_tile (strcat "JB_1_"(car X))(cadr X)))
    (list
      (list "e1" (cdr(assoc "JB_1_e1" Settings&dbox1)))
      (list "e2" (cdr(assoc "JB_1_e2" Settings&dbox1)))
      (list "e3" (cdr(assoc "JB_1_e3" Settings&dbox1)))
      (list "e4" (cdr(assoc "JB_1_e4" Settings&dbox1)))
      (list "e5" (cdr(assoc "JB_1_e5" Settings&dbox1)))
      (list "e6" (cdr(assoc "JB_1_e6" Settings&dbox1)))
      (list "e7" (cdr(assoc "JB_1_e7" Settings&dbox1)))
      (list "e8" (cdr(assoc "JB_1_e8" Settings&dbox1)))
      (list "e9" (cdr(assoc "JB_1_e9" Settings&dbox1)))
      (list "e0" (cdr(assoc "JB_1_e0" Settings&dbox1)))
      
      )
    )
  )
;;;DBox1, moden
(defun JB_TTP:Dbox1:mode ( / )
  (if error&DBox1
    (mode_tile (strcat "JB_1_" error&DBox1)2)
    (mode_tile "JB_1_e1" 2)
    )
  )

;;;PAN
(defun JB_TTP:Dbox1:exe:Pan (pList w PanDist / MP P PANDIST W1)
  (setq mp (JBf_Zoom:BildschirmMittelpunkt))
  (setq pList (cons (trans mp 1 0) pList))
  (setq w1 (angle (trans'(0 0 0)1 0)(trans'(1 0 0)1 0)))
  (setq w1 (+ w1 w))
  (setq p (polar (trans mp 1 0)w1 PanDist))
  (JBf_Zoom:Pan2Pkt p)
  pList)

;;;Ausfhrung
(defun JB_TTP:Dbox1:exe ( / ENDFLAG GRREADRET KEYLIST PANDIST PLIST pListFirst W)
  (setq keyList (vl-string->list
                  (apply 'strcat
                         (list (cdr(assoc "JB_1_e1" Settings&dbox1))
                               (cdr(assoc "JB_1_e2" Settings&dbox1))
                               (cdr(assoc "JB_1_e3" Settings&dbox1))
                               (cdr(assoc "JB_1_e4" Settings&dbox1))
                               (cdr(assoc "JB_1_e5" Settings&dbox1))
                               (cdr(assoc "JB_1_e6" Settings&dbox1))
                               (cdr(assoc "JB_1_e7" Settings&dbox1))
                               (cdr(assoc "JB_1_e8" Settings&dbox1))
                               (cdr(assoc "JB_1_e9" Settings&dbox1))))))

  (setq PanDist (atof(cdr(assoc "JB_1_e0" Settings&dbox1))))
    
  (princ "\nMit ENTER zurck ins Dialogfenster.")

  (while (and(not EndFlag)(member(car (setq grreadRet (grread 't 5 0)))'(5 12 2 25 11)))

    (princ "\rMit ENTER zurck ins Dialogfenster.")

    (if (and(=(car grreadRet)2)
            (member (cadr grreadRet) keyList))
      (cond ((= (cadr grreadRet)(nth 0 keyList));;;1
             (setq w (*(/ ( * 2.0 pi) 8.0)5.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 1 keyList));;;2
             (setq w (*(/ ( * 2.0 pi) 8.0)6.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 2 keyList));;;3
             (setq w (*(/ ( * 2.0 pi) 8.0)7.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 5 keyList));;;6
             (setq w (*(/ ( * 2.0 pi) 8.0)0.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 8 keyList));;;9
             (setq w (*(/ ( * 2.0 pi) 8.0)1.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 7 keyList));;;8
             (setq w (*(/ ( * 2.0 pi) 8.0)2.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 6 keyList));;;7
             (setq w (*(/ ( * 2.0 pi) 8.0)3.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 3 keyList));;;4
             (setq w (*(/ ( * 2.0 pi) 8.0)4.0))
             (setq pList (JB_TTP:Dbox1:exe:Pan pList w PanDist))
             (setq pListFirst 'T)
             )

            ((= (cadr grreadRet)(nth 4 keyList))
             (if pList
               (progn
                 (JBf_Zoom:Pan2Pkt (car pList))
                 (setq pList (cdr pList))
                 )
               (if pListFirst
                 (alert "Es wurden bereits alle PAN-Schritte rckgngig gemacht.")
                 (alert "Es sind noch keine PAN-Schritte gemacht worden.")
                 )
               )
             )
            )
      )
    
    (if
      (or(and(=(car grreadRet)2);;;wenn Tastenauswertung
             (=(cadr grreadRet)13));;;wenn Rechtsklick oder ENTER
         (member (car grreadRet)' (25 11));;;25 ist in ACAD, 11 in BRICSCAD der Rechtsklick
         )
      (setq EndFlag 'T))
    )
  )
   
;;;DCL-schreiben
(defun JB_TTP:dcl:Write ( / file)  
  (if (and (setq JB_TTP_$DCL$_File (vl-filename-mktemp (strcat "TTP.dcl")))
           (setq file (open JB_TTP_$DCL$_File "w"))
      )
    (progn
      (mapcar '(lambda (A)
                       (write-line A file)
               )
              (mapcar '(lambda (A)
                               (strcat "\n" A)
                       )
              (list
                "//Hauptdialog"
                "JB_TTP_1: dialog {label= \"Tastatur-PAN\";	 "
                ":boxed_column {label = \"Einstellungen\";"
                ":row{alignment=centered;"
                ":edit_box {key = \"JB_1_e7\"; edit_width = 2; allow_accept=true;}"
                ":edit_box {key = \"JB_1_e8\"; edit_width = 2; allow_accept=true;}"
                ":edit_box {key = \"JB_1_e9\"; edit_width = 2; allow_accept=true;}}"
                ":row{alignment=centered;"
                ":edit_box {key = \"JB_1_e4\"; edit_width = 2; allow_accept=true;}"
                ":edit_box {key = \"JB_1_e5\"; edit_width = 2; allow_accept=true;}"
                ":edit_box {key = \"JB_1_e6\"; edit_width = 2; allow_accept=true;}}"
                ":row{alignment=centered;"
                ":edit_box {key = \"JB_1_e1\"; edit_width = 2; allow_accept=true;}"
                ":edit_box {key = \"JB_1_e2\"; edit_width = 2; allow_accept=true;}"
                ":edit_box {key = \"JB_1_e3\"; edit_width = 2; allow_accept=true;}}"
                ":button {key = \"JB_1_b1\"; label = \"Vorgabeeinstellungen\";}"
                ":spacer {height=1;}"
                ":edit_box {key = \"JB_1_e0\"; label = \"PAN-Distanz\"; edit_width = 6;allow_accept=true;}"
                "}"
                ":row{fixed_width = true;alignment = centered;"
                ":button {key = \"accept\"; label = \"&PAN starten<\";width=20; is_default=true;}"
                ":spacer {width = 2;}"
                ":retirement_button {label = \"&Ende\"; key= \"cancel\"; fixed_width = true;is_cancel=true;}"
                "}"
                "}"
               


               )
              )
      )
      (close file)
      JB_TTP_$DCL$_File
    )
  )
)
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine verwaltungstechnische Funktionen							   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Fehlermeldung
;;;Fehlermeldung;;;
(defun JBf_Error  (s)
  (print (strcat "***Fehler*** " s))
  (JBf_Reinit))

;;;Initialisierungsfunktion
(defun JBf_init (InitVaris / )
  (setq	JB_Error *error*
        *error* JBf_Error)
  (vl-load-com)
  ;;;Systemvariablen aktuelle Einstellungen fr ReInit speichern
  (setq JBf$ReInit$Varis
         (mapcar '(lambda(A)
                    (list (car A)(getvar (car A))))InitVaris))
  ;;;Vorgabeeistellungen fr Systemvariablen
  (mapcar '(lambda(A)
             (if (cadr A)
               (setvar (car A)(cadr A))))InitVaris)
  )

;;;Reinitialisierung
(defun JBf_Reinit ( / n)
  ;;;Systemvariablen ReInitialisieren
  (mapcar '(lambda(A)
             (setvar (car A)(cadr A)))JBf$ReInit$Varis)
  (setq JBf$ReInit$Varis nil)
  (princ)
)
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Strings								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;benutzerspezifischer Pfad zum Speichern von Programmeinstellungen auf dem Benutzer von Windows
;;;bergeben wird der relative Pfad, der hinter den Windows-Pfad angehngt wird. Wenn die Verzeichnisse nicht vorhanden sind werden sie erstellt.
(defun JBf_String:Userpfad:WinUser (UserPfad / )
  
  (setq UserList (JBf_String:Delimiter->List UserPfad "\\"))
  (setq Pfad (strcat "c:\\Users\\"(getvar "LOGINNAME")"\\"))
        

  ;;;wenn UserPfad noch nicht vorhanden, dann erstellen
  (mapcar '(lambda(A)
             (setq Pfad (strcat Pfad A "\\"))
             (if (not (JBf_String:FilePath? Pfad))
               (vl-mkdir Pfad)))
    UserList)
  Pfad
  )
;;;String anhand Trennzeichen in Liste zurckgeben
(defun JBf_String:Delimiter->List (Str Delim / StrList)
  (setq Str (vl-string-left-trim Delim Str)
	Str (vl-string-right-trim Delim Str))
  (if (vl-string-search Delim Str)
    (progn
      (while (vl-string-search Delim Str)
        (setq StrList (cons (substr Str 1 (vl-string-search Delim Str))StrList)
	      Str (vl-string-left-trim Delim(substr Str(+(vl-string-search Delim Str)(+ (strlen Delim)1))))))
      (if (/= Str "")
        (setq StrList (cons Str StrList))))
    (setq StrList (cons Str StrList)))
  (reverse StrList))


;;;Dateipfad prfen
(defun JBf_String:FilePath? (Pfad / FSO TRUE-FALSE)
  (setq Pfad (if(vl-string-search "." Pfad)(car(fnsplitl  Pfad))Pfad))
  (if (setq FSO (vlax-create-object "Scripting.FilesystemObject"))
    (progn
      (if (vlax-method-applicable-p FSO 'FOLDEREXISTS)
        (setq TRUE-FALSE
               (=(vl-catch-all-apply
                   'vlax-invoke-method
                   (list FSO 'FOLDEREXISTS Pfad)):vlax-true))
        (vlax-release-object FSO))))
  TRUE-FALSE)
	  
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Es wird der GcN-Eintrag gesubst
(defun JBf_list:subst:gc (liste Wert GcN / )
  (subst (cons GcN Wert)(assoc GcN liste)liste))


;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine VLa-Funktionen 							       			   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


;;;PANNEN auf Punkt
;;;ZoomFunktion zum "pannen"
(defun JBf_Zoom:Pan2Pkt (pkt / )
  (vla-zoomcenter (vlax-get-acad-object) (vlax-3d-point pkt) (getvar "VIEWSIZE"))
  )


;;;aktueller Bildschirmmittelpunkt
(defun JBf_Zoom:BildschirmMittelpunkt ( / )
  (mapcar '(lambda(A)(/ A 2.0))
  (mapcar '+
  (list (- (car (getvar "viewctr")) (/ (* (getvar "viewsize") (/ (car (getvar "screensize")) (cadr (getvar "screensize")))) 2))
        (- (cadr (getvar "viewctr")) (/ (getvar "viewsize") 2))0.0)
  (list (+ (car (getvar "viewctr")) (/ (* (getvar "viewsize") (/ (car (getvar "screensize")) (cadr (getvar "screensize")))) 2))
        (+ (cadr (getvar "viewctr")) (/ (getvar "viewsize") 2))
        0))))







;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen in SIC-Datei sichern  					   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Liste in LSP-Datei sichern
;;;Sichern von Einstellungen, Ausfhrung
;;;liste => DottetPairList, die es zu sichern gilt
;;;path => vollstndiger Dateipfad mit Dateiname
;;;AcadTrustCheck => 'T or NIL, es wird bei 'T ein temnporrer TrustedPath erstellt und danach auch gleich wieder gelscht
(defun JBf_SIC:sichern (liste FilePath AcadTrustCheck / FILESTREAM X)

  (setq FileStream (open FilePath "w"))
  (write-line "'(" FileStream)
  (mapcar '(lambda (X)
                   (JBf_SIC:sichern:prin1 X FileStream)
           )
          liste
  )
  (write-line ")" FileStream)
  (close FileStream)

  (if
    (if AcadTrustCheck
      (car (JBf_SIC:load:Catch FilePath nil))
      (vl-catch-all-error-p
        (vl-catch-all-apply 'JBf_SIC:load (list FilePath))
      )
    )


    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (progn
        (alert (strcat "Die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n ist fehlerhaft und wird automatisch durch die BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nersetzt."
               )
        )
        (if (vl-file-delete FilePath)
          (vl-file-copy (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak") FilePath)
          (alert (strcat "Die Sicherungsdatei \n\n"
                         FilePath
                         "\n\n ist fehlerhaft und konnte nicht automatisch durch die BAK-Datei\n\n"
                         (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                         "\n\nersetzt werden. Bitte fhren Sie diesen Arbeitsgang manuell durch."
                 )
          )
        )
      )

      (alert (strcat "Die Sicherungsdatei \n\n"
                     FilePath
                     "\n\n ist fehlerhaft, bitte lschen Sie diese, anderfalls kann das Programm nicht mehr\n"
                     "ordnungsgem starten."
             )
      )
    )
    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (if (vl-file-delete (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (alert (strcat "Fr die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n konnte keine BAK-Datei erstellt werden. Bitte lschen Sie die vorh. BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nmanuell."
               )
        )
      )
      (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
    )
  )
)
;;;Laden der Datei um zu prfen, ob diese korrekt ist!
  (defun JBf_SIC:load (FilePath /)
    (load FilePath)
  )
;;;Pfad muss existieren, Prfung in aufrufender Funktion und temporrem TrustPath
  (defun JBf_SIC:load:Catch (PathFile ErrMsg / ERROR RETVAL TRUTHPATHSET)
    (if (JBf_AcadSystem:TrustedPaths?)
      (progn
        (setq TruthPathSet 'T)
        (JBf_AcadSystem:TrustedPaths:Add (strcat (car (fnsplitl PathFile)) "..."))
      )
    )

    (setq error (vl-catch-all-error-p
                  (setq RetVal (vl-catch-all-apply 'JBf_SIC:load (list PathFile)))
                )
    )
    (if (and error ErrMsg)
      (alert ErrMsg)
    )

    (if TruthPathSet
      (JBf_AcadSystem:TrustedPaths:Delete (strcat (car (fnsplitl PathFile)) "..."))
    )
    (list error RetVal)
  )
;;;Iteratives lustiges Listenschreiben
  (defun JBf_SIC:sichern:prin1 (A FileStream / B)

    (cond  ;;;wenn einzelner Eintrag
                 ((atom A)
                        (write-line (vl-prin1-to-string A) FileStream)
                 )
      ((and (atom (car A)) (not (cdr A)))  ;;;GC ohne Wert
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (not (listp (cdr A))))  ;;;DottedPair
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)) (= (length (cdr A)) 1) (atom (car (cdr A))))  ;;;GC + Wert
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)))  ;;;GC + Liste
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ( 'T
        (write-line "(" FileStream)
        (mapcar '(lambda (B)
                         (JBf_SIC:sichern:prin1 B FileStream)
                 )
                A
        )
         (write-line ")" FileStream)
      )
    )
  )             

;;;--------------------------------------------------------------------------------------------------------
;;;Setzen von "TrustedPaths's" sab ACAD  2014								   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Prfen, ob bereits TrustedPaths in der aktuelle Version verwendet werden knnen
(defun JBf_AcadSystem:TrustedPaths? ( / )
  (and (= "ACAD" (strcase (getvar "PROGRAM"))) (getvar "SECURELOAD"))
  )

;;;Pfadangaben immer mit BackSlashes, "\\..." hinten angestellt, damit alle untergeordneten Verzeichnisse bercksichtigt werden
(defun JBf_AcadSystem:TrustedPaths:Add (pfad / TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (if(not(member (strcase pfad)(mapcar 'strcase (JBfd_AcadSystem:TrustedPath:Split TrustedPaths))))
    (setvar "TRUSTEDPATHS"(strcat TrustedPaths ";" pfad)))
  )

;;;Pfad entfernen
(defun JBf_AcadSystem:TrustedPaths:Delete (pfad / A TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (setvar "TRUSTEDPATHS"
	  (vl-string-right-trim ";"(apply 'strcat(mapcar '(lambda(A)
							   (strcat A ";"))
							(vl-remove-if 'not (mapcar '(lambda(A)
										      (if(/= (strcase pfad)(strcase A))A))
										   (JBfd_AcadSystem:TrustedPath:Split TrustedPaths)))))))
  )

;;;String splitten an Semikolons, als Liste zurckgeben
(defun JBfd_AcadSystem:TrustedPath:Split (TrustedPaths / A RETLIST TEMP)
  (mapcar '(lambda(A)
	     (if (/= A 59)
	       (setq temp (cons A temp))
	       (setq RetList (cons (vl-list->string(reverse temp))RetList)
		     temp nil))
	     )
	     (vl-string->list TrustedPaths))
  (if temp
    (setq RetList (cons (vl-list->string (reverse temp))RetList)))
  (reverse RetList))
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Dcl									   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;DCL-Dialogfenster laden
(defun JBf_Dcl:Load_dialog (FileName DialogName JB_$DCL$_x_po / DclId)
  (setq DclId (load_dialog FileName))
  (if	JB_$DCL$_x_po
    (if (not (new_dialog DialogName DclId "" JB_$DCL$_x_po))
      (exit))
    (if (not (new_dialog DialogName DclId))
      (exit)))
  DclId
  )

;;;--------------------------------------------------------------------------------------------------------
;;;Info fr Textfenster nach dem laden des Programms							   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(princ (strcat
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          "\n|Tastatur-PAN.                                               |"
          "\n|------------------------------------------------------------|"
          "\n|erstellt durch Bosse-engineering - www.bosse-engineering.com|"
          "\n|------------------------------------------------------------|"
          "\n|Befehlszeilenaufruf: TTP                                    |"
          "\n|Befehlszeilenaufruf: TTPS (Settings)                        |"
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          )
       )
(princ)





  










